//	CDialogFormatDisk.c

//#include "Carbon68kGlue.h"
//#include "ADFS_LogFile.h"
//#include "ADFS_Menus.h"
//#include "ADFS_Commands.h"
#include "ADFS_Prefs.h"
#include "MainEvent.h"
#include "PhysicalFloppy.h"
#include "CDialogFormatDisk.h"

/********************************************************/

DGI_ItemRec		gDlgFormat_ItemTable[kFormat_ItemStr_NUMTYPES] = {
	{	kFormat_ItemStr_VERB,	
		"Formatting the disk will over-write all the data on "
		"the disk.  Are you sure you want to format it?", 
		teJustLeft, normal	}
};

/********************************************************/

OSErr		DoFormatDiskDialog(PhysVolumeRec *volRecP)
{
	OSErr					err			= noErr;
	CDialogFormatDisk		*dialogP	= NULL;
		
	dialogP = new CDialogFormatDisk;
	
	if (dialogP) {
		if (!dialogP->IDialogFormatDisk()) {
			dialogP->Dispose();
			dialogP = NULL;
			err = 1;
		} else {
			Boolean		formatB;
			FSType		formatType;
			
			do {
				HandleOneEvent(10);
			} while (!dialogP->i_buttonPressed);
			
			formatB		= dialogP->i_buttonPressed == kFormat_FORMAT;
			formatType	= dialogP->i_formatType;
			dialogP->Dispose();
			
			if (!formatB) {
				err = 1;
			} else {
				err = FormatFloppy(volRecP, formatType);
			}
		}
	}

	return err;
}

/********************************************************/
Boolean		CDialogFormatDisk::IDialogFormatDisk(void)
{
	Boolean		success = TRUE;
	
	//	get it hidden, then show
	success = _inherited::IDialog(ADFS_Window_MODAL_DIALOG, 205);
	
	if (success) {		
		GetSmallFontRec(&i_fontRec);

		memcpy(
			i_itemStrTable, gDlgFormat_ItemTable, 
			sizeof(DGI_ItemRec) * kFormat_ItemStr_NUMTYPES);

		SetDlgItemUseStdDraw(kFormat_VERBAGE);
	}

	if (success) {
		i_buttonPressed = kFormat_NONE;
		i_formatType	= FSType_PRO;

		ValueConvert(DGI_ValueConvert_TO, kFormat_OS_POP);

		SetDialogDefaultItem(GetDialogRef(), kFormat_CANCEL);
		SetDialogCancelItem(GetDialogRef(), kFormat_CANCEL);
	}

	if (success) {
		Rect		windR	= (**gPrefsH).windA[PREF_Wind_FORMAT_DISK];
		
		if (!EmptyRect(&windR)) {
			MoveWindow(
				GetWindowRef(), 
				windR.left, 
				windR.top, 
				FALSE);
		}
		
		ShowWindow(GetWindowRef());
	}
	
	if (success) {
		SetModalUp(TRUE);
	}

	return success;
}

void		CDialogFormatDisk::Dispose(void)
{
	_inherited::Dispose();
	SetModalUp(FALSE);
}

void	CDialogFormatDisk::DoKeyDown(EventRecord *event)
{
	_inherited::DoKeyDown(event);
}

void	CDialogFormatDisk::DoClick(EventRecord *event)
{
	if (FrontWindow() != GetWindowRef()) {
		_inherited::DoClick(event);
	} else {
		DialogRef		theDialog;
		short			itemHit;
		
		DialogSelect(event, &theDialog, &itemHit);

		switch (itemHit) {
		
			case kFormat_FORMAT:
			case kFormat_CANCEL: {
				i_buttonPressed = itemHit;
				break;
			}
				
			case kFormat_OS_POP: {
				ValueConvert(DGI_ValueConvert_FROM, itemHit);
				break;
			}
		}
	}
}

void	CDialogFormatDisk::Move(EventRecord *event)
{
	_inherited::Move(event);
	(**gPrefsH).windA[PREF_Wind_FORMAT_DISK] = GetWindowRect(WindowRect_ALL_GLOBAL);
	SavePrefs();
}

void	CDialogFormatDisk::DialogItemStandardDrawProc(
	DialogItemIndex	itemNo, 
	Rect			*itemRectP)
{
	char				str1[256];
//	unsigned char		*str1P		= (unsigned char *)str1;
	Boolean				drawStringB	= TRUE;
	short				justifyS	= teJustLeft;
	
	Prepare();

	switch (itemNo) {
		
		case kFormat_VERBAGE: {
			short	tableIndex = GetItemTableIndex(
				i_itemStrTable, itemNo, kFormat_ItemStr_NUMTYPES);
			
			strcpy(str1, i_itemStrTable[tableIndex].itemStr);
			justifyS = i_itemStrTable[tableIndex].justifyS;
			TextFace(i_itemStrTable[tableIndex].face);
			break;
		}
	}

	if (drawStringB) {
		DrawCStringInRect(str1, itemRectP, justifyS);
	}
}

void		CDialogFormatDisk::ValueConvert(
	DGI_ValueConvertType	convertType, 
	short					dlgItem)
{
	ControlRef		controlRef = GetDlogItemControl(dlgItem);
//	Boolean			convertFromB = FALSE;
	
	switch (dlgItem) {
		
		case kFormat_OS_POP: {
			if (convertType == DGI_ValueConvert_TO) {
				SetControlValue(
					controlRef, 1 + i_formatType == FSType_PAS);
			} else {
				i_formatType = (ushort)GetControlValue(controlRef) == 1 
					? FSType_PRO : FSType_PAS;
			}
			break;
		}
	}
}
